/*
 *  File:		color.c
 *  Function:	color "menu"
 *  Author:		Paul Elseth
 *				Copyright (c) 1991, Paul Elseth
 *
 *	Change History:
 *
 *		12/20/91	PBE		added tool palette
 *		12/08/91	PBE		created
 */

#ifndef __COLOR__
#include "color.h"
#endif

#ifndef __EDITOR__
#include "editor.h"
#endif
#ifndef	__UTILS__
#include "utils.h"
#endif
#ifndef __QDAUX__
#include <qdaux.h>
#endif
#ifndef	__OPTIONS__
#include "options.h"
#endif

#pragma noroot


/*
 *	InvertTool()
 *		Invert a tool.
 */
static
void InvertTool(short toolNum, Rect *infoRect)
{
	short	toolBoxWidth;
    Rect	r;

	toolBoxWidth = (gToolsPicWidth - 2) / 5;

   	r.v1 = infoRect->v1 + 3;
	r.v2 = r.v1 + gToolsPicHite - 2;

	r.h1 = infoRect->h1 + 8 + toolNum * toolBoxWidth;
	r.h2 = r.h1 + toolBoxWidth - 2;

	InvertRect(&r);
}


/*
 *	DrawColorBar()
 *		Draw the colorbar in the window's infoBar.
 */
#pragma databank	1
#pragma toolparms	1
pascal void DrawColorBar(Rect *infoRect, long infoRefCon, WindowPtr wp)
{
	IconData		**dataH;
	Pattern			pat;
	Rect			r;
	unsigned short	color;

	dataH = (IconData **) GetPrivateData(wp);

    if (gToolsPicH != nil) {
	    r.v1 = infoRect->v1 + 2;
        r.h1 = infoRect->h1 + 6;
        r.v2 = r.v1 + gToolsPicHite;
        r.h2 = r.h1 + gToolsPicWidth;
		DrawPicture(gToolsPicH, &r);

		InvertTool((**dataH).tool, infoRect);
	    }

/* draw the current color: */
	r.v1 = infoRect->v1 + 2;
	r.v2 = r.v1 + 15;
	r.h1 = infoRect->h1 + gToolsPicWidth + 14;
	r.h2 = r.h1 + kCurColorWidth;

    FrameRect(&r);

    InsetRect(&r, 4, 2);

	color = (**dataH).color;

	MakePattern(color, pat);
    FillRect(&r, pat);

	color = 0;

	r.v1 = infoRect->v1 + 2;
	r.v2 = r.v1 + 8;
	r.h1 = infoRect->h1 + gToolsPicWidth + 14 + kCurColorWidth - 1;
        
	while (color < 0x8888) {
		r.h2 = r.h1 + 34;
		SpecialRect(&r, 0, color);
		r.v1 = r.v2 - 1;
		r.v2 = r.v1 + 8;
		SpecialRect(&r, 0, color ^ 0xffff);
		r.v1 = r.v1 - 7;
		r.v2 = r.v1 + 8;
		r.h1 = r.h2 - 2;

		color += 0x1111;
		}
}
#pragma toolparms	0
#pragma databank	0


/*
 *	SelectColor()
 *		Select a color from the color bar.
 */
void SelectColor(EventRecord *event)
{
	IconData		**dataH;
	WindowPtr		wp;
    Rect			r;
	Point			pt;
	Pattern			pat;
	unsigned short	x, y, color;
    
    wp = (WindowPtr) event->wmTaskData;
	if (wp != FrontWindow())
		return;

	dataH = (IconData **) GetPrivateData(wp);

	pt = event->where;
	StartInfoDrawing(&r, wp);
    GlobalToLocal(&pt);

/* in tools? */
	if ((pt.v >= r.v1 + 2) && (pt.v <= r.v1 + 2 + gToolsPicHite)
    	&& (pt.h >= r.h1 + 6) && (pt.h <= r.h1 + 6 + gToolsPicWidth)) {
		x = (pt.h - r.h1 - 6) / ((gToolsPicWidth - 1) / 5);
        if (x < 5 && (**dataH).tool != x) {
            InvertTool((**dataH).tool, &r);
			(**dataH).tool = x;
            InvertTool(x, &r);
			}
	    }
/* in colors? */
	else if ((pt.v >= r.v1 + 1) && (pt.h >= (r.h1 + gToolsPicWidth + 14 + kCurColorWidth))) {
	    y = pt.v - (r.v1 + 1);
		x = (pt.h - r.h1 - gToolsPicWidth - 14 - kCurColorWidth) / 32;
		if (x < 8 && y > 1 && y < 17) {
			if (y > 9)
				x ^= 0x000f;
			color = MakeColor(x);
			(**dataH).color = color;

			r.v1 += 4;
		    r.v2 = r.v1 + 11;
			r.h1 += gToolsPicWidth + 18;
			r.h2 = r.h1 + kCurColorWidth - 8;

			MakePattern(color, pat);
    		FillRect(&r, pat);
			}
		}

	EndInfoDrawing();
}


/*
 *	MakeColor()
 *		Transform the color index into the actual color.
 */
short MakeColor(short color)
{
	asm {
		lda	color
		and	#0x000f
        pha
		asl	a
		asl	a
		asl	a
		asl	a
		ora	1,s
	    plx
        sta	color
		}

	return color;
}


/*
 *	UpdateColor()
 *		Update the current color for this icon window.
 */
void UpdateColor(IconData **dataH, short color)
{
	Pattern	pat;
	Rect	r;

	if (color == -1)
		color = (**dataH).color;
	else
        (**dataH).color = color;

	StartInfoDrawing(&r, GetPort());

	r.v1 += 4;
    r.v2 = r.v1 + 11;
	r.h1 += gToolsPicWidth + 18;
	r.h2 = r.h1 + kCurColorWidth - 8;

	MakePattern(color, pat);
	FillRect(&r, pat);

    EndInfoDrawing();
}
